<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\API\Entity\Storefront\Product\Compact as ProductCompact;
use XCart\Bundle\APIPlatformBridgeBundle\Filter\IdIntegerFilter;

class AddProductFilterByBrandFieldPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $dtoGeneratorConfigName = 'xcart.dto_generator.config';

        if ($container->getParameter($dtoGeneratorConfigName)) {
            /** @var array[] $dtoGeneratorConfig */
            $dtoGeneratorConfig = $container->getParameter($dtoGeneratorConfigName);

            $compactProductApiEntity        = $dtoGeneratorConfig['entities']['api'][ProductCompact::class];
            $compactProductApiEntityFilters = $compactProductApiEntity['filters'] ?? [];

            $isIdIntegerFilterAlreadyExisted = false;
            foreach ($compactProductApiEntityFilters as $key => $filter) {
                if ($filter['className'] === IdIntegerFilter::class) {
                    $isIdIntegerFilterAlreadyExisted                      = true;
                    $compactProductApiEntityFilters[$key]['properties'][] = 'brandId';

                    break;
                }
            }

            if (!$isIdIntegerFilterAlreadyExisted) {
                $compactProductApiEntityFilters[] = [
                    'className'  => IdIntegerFilter::class,
                    'properties' => ['brandId'],
                    'arguments'  => [],
                    'operations' => [],
                ];
            }

            $dtoGeneratorConfig['entities']['api'][ProductCompact::class]['filters'] = $compactProductApiEntityFilters;

            $container->setParameter($dtoGeneratorConfigName, $dtoGeneratorConfig);
        }
    }
}
