<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\DataSource\Product\Applier;

use ApiPlatform\Core\Exception\InvalidArgumentException;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\StringValue;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;

class BrandApplier implements ApplierInterface
{
    public function __construct(
        private ReadRepositoryInterface $brandRepository
    ) {
    }

    /**
     * @param StringValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $brand = $this->brandRepository->find(
            $filterValue->getValue()
        );

        if (!$brand) {
            throw new InvalidArgumentException("Brand with id=\"{$filterValue->getValue()}\" is not found");
        }

        if ($option = $brand->getOption()) {
            $queryBuilder->linkInner('entity.attributeValueS', 'brandAttributeValue')
                ->linkInner('brandAttributeValue.attribute_option', 'brandOption')
                ->andWhere('brandOption.id = :brandOptionId')
                ->setParameter('brandOptionId', $option->getId());
        }

        return $queryBuilder;
    }
}
