<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\DataSource\Brand\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\StringValue;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class FirstLetterApplier implements ApplierInterface
{
    /**
     * @param StringValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        $firstLetter = $filterValue->getValue()[0];

        return $queryBuilder
            ->linkLeft('entity.option')
            ->linkLeft('option.translations')
            ->andWhere('translations.name LIKE :firstLetter')
            ->setParameter('firstLetter', "{$firstLetter}%");
    }
}
