<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ShopByBrand\API\Endpoint\Storefront\Brand\Detailed\GetOneByCleanURL\Assembler;

use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\Factory\Request\RequestFactoryInterface;

class RequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestFactoryInterface $requestFactory
    ) {
    }

    /**
     * @param string $id
     *
     * @return Request
     */
    public function assemble($id): RequestInterface
    {
        return $this->requestFactory->create()
            ->setCleanURL($id);
    }
}
