/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Brand list
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function BrandsListView(base)
{
  BrandsListView.superclass.constructor.apply(this, arguments);
}

extend(BrandsListView, ListView);

function BrandsListController(base)
{
  BrandsListController.superclass.constructor.apply(this, arguments);
}

extend(BrandsListController, ListsController);

BrandsListController.prototype.name = 'BrandsListController';

BrandsListController.prototype.findPattern += '.items-list-brands';

BrandsListController.prototype.getListView = function()
{
  return new BrandsListView(this.base);
};

BrandsListView.prototype.getFilterByTypes = [
  'first_letter',
  'substring'
];

BrandsListView.prototype.postprocess = function(isSuccess, initial)
{
  BrandsListView.superclass.postprocess.apply(this, arguments);

  var o = this;

  if (isSuccess) {
    // Manual set cell's height
    this.base.find('table.products-grid tr').each(
      function () {
        var height = 0;
        jQuery('div.product', this).each(
          function() {
            height = Math.max(height, jQuery(this).height());
          }
        );
      }
    );

    jQuery('.brands-filter-by-substring input#substring', this.base).keypress(
      function (event) {
        if (event.which === 13) {
          event.preventDefault();
          jQuery('.filter-by-substring-button').trigger('click');
        }
      }
    );

    jQuery('.brands-filter-by-first-letter .filter-item.clickable, .filter-by-substring-button', this.base).click(
      function () {
        const href = new URL(window.location.href);
        const $this = jQuery(this);
        const isFilterByFirstLetter = $this.hasClass('filter-item');

        const filterValue = isFilterByFirstLetter
          ? $this.closest('li').data('filter-value')
          : $this.siblings('div.substring').find('input#substring').val()

        const filterBy = isFilterByFirstLetter
          ? 'first_letter'
          : 'substring';

        for (let i = 0; i < o.getFilterByTypes.length; i++) {
          const filterType = o.getFilterByTypes[i];
          href.searchParams.delete(filterType);
          delete o.widgetParams[filterType];
        }

        if (filterValue !== undefined) {
          href.searchParams.set(filterBy, filterValue);
        }

        o.widgetParams[filterBy] = filterValue;
        window.history.pushState(null, null, href.toString());

        return !o.load();
      }
    );
  }
};

// Get event namespace (prefix)
BrandsListView.prototype.getEventNamespace = function()
{
  return 'list.brands';
};

/**
 * Load brand lists controller
 */
xcart.autoload(BrandsListController);
