/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Product selection button controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function PopupAddBrandProduct(base)
{
  PopupAddBrandProduct.superclass.constructor.apply(this, arguments);
}

extend(PopupAddBrandProduct, PopupButton);

PopupAddBrandProduct.prototype.pattern = '.popup-product-brand-selection';

decorate(
  'PopupAddBrandProduct',
  'callback',
  function (selector)
  {
    // Some autoloading could be added
    xcart.autoload(TableItemsListQueue);
    xcart.autoload(CommonForm);
    xcart.autoload(StickyPanelProductSelection);
    SearchConditionBox();
  }
);

decorate(
  'PopupAddBrandProduct',
  'getURLParams',
  function ()
  {
    var params = arguments.callee.previousMethod.apply(this, arguments);

    return params;
  }
);

xcart.autoload(PopupAddBrandProduct);

xcart.microhandlers.add(
  'PopupAddBrandProduct',
  PopupAddBrandProduct.prototype.pattern,
  function (event) {
    xcart.autoload(PopupAddBrandProduct);
  }
);
