<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Returns\Model\Repo;

use QSL\Returns\Model\ReturnReasonTranslation;
use XLite\Model\Repo\ModelRepoTranslationTrait;

/**
 * Return reason repository
 *
 */
class ReturnReason extends \XLite\Model\Repo\ARepo
{
    use ModelRepoTranslationTrait;

    public const SEARCH_ORDER_BY = 'orderBy';
    public const SEARCH_LIMIT   = 'limit';

    /**
     * Current condition
     *
     * @var \XLite\Core\CommonCell
     */
    protected $currentSearchCnd = null;

    // {{{ Search

    // }}}

    public function getTranslationDataFromYamlStructure(array $entity, string $lngCode): ?array
    {
        if (
            ($result = $this->getTranslationFromYamlStructure($entity, $lngCode))
            && !empty($result['reasonName'])
        ) {
            return [
                $result['reasonName']
            ];
        }

        return null;
    }

    public function getTranslationDataFromModel(ReturnReasonTranslation $translation): ?array
    {
        return [
            $translation->getReasonName()
        ];
    }
}
