<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ProductStickers\Transformer\XLite\Model\Product\Logic\Entity\Storefront;

use XCart\Logic\Entity\Storefront\Sticker;
use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductInterface;
use XLite\Model\Product as Source;
use XCart\Logic\Entity\Storefront\Product as Target;

class ProductDecorator implements ProductInterface
{
    public function __construct(
        private ProductInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        $target->setStickers($this->getTransformedStickers($input));

        return $target;
    }

    /**
     * @return Sticker[]
     */
    private function getTransformedStickers(Source $input): array
    {
        $transformedStickers = [];

        /* @var \QSL\ProductStickers\Model\ProductSticker $sticker */
        foreach ($input->getPublicProductStickers() as $sticker) {
            if ($sticker['enabled']) {
                $transformedStickers[] = (new Sticker())
                    ->setLabel($sticker['name'])
                    ->setBgColor($sticker['bg_color'])
                    ->setTextColor($sticker['text_color']);
            }
        }

        return $transformedStickers;
    }
}
