<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ProductStickers\Core;

use QSL\ProductStickers\Model\ProductSticker;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("QSL\ProductStickers")
 */
class Translation extends \XLite\Core\Translation
{
    public static function getModelsToExportTranslations(): array
    {
        return array_merge(
            parent::getModelsToExportTranslations(),
            [
                ProductSticker::class
            ]
        );
    }
}
