/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * PopupButtonFeedCategoriesButton
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function PopupButtonFeedCategoriesButton() {
  PopupButtonFeedCategoriesButton.superclass.constructor.apply(this, arguments);
}

extend(PopupButtonFeedCategoriesButton, PopupButton);

PopupButtonFeedCategoriesButton.prototype.pattern = '.feed-categories-button';

/*
 * Copy data (IDs of selected items) prepared in
 * View\Button\RemindSelectedButton::prepareURLParams()
 * to the data to be sent to the server on the form submit.
 */
decorate(
    'PopupButtonFeedCategoriesButton',
    'getURLParams',
    function (button) {
        var urlParams = arguments.callee.previousMethod.apply(this, arguments);
        jQuery('[name*="select"]:checked').each(function (index, elem) {
            urlParams[elem.name] = 1;
        });
        return urlParams;
    }
);

/*
 * In this function we unlink the dialog (closed by that time)
 * after submitting the dialog form.
 */
decorate(
    'PopupButtonFeedCategoriesButton',
    'eachClick',
    function (elem) {
        if (elem.linkedDialog) {
            jQuery(elem.linkedDialog).dialog('close').remove();
            elem.linkedDialog = undefined;
        }

        return arguments.callee.previousMethod.apply(this, arguments);
    }
);

/*
 * In this function we untick selected products after submitting
 * the dialog form.
 */
decorate(
    'PopupButtonFeedCategoriesButton',
    'afterSubmit',
    function (selector) {
        // previous method call
        arguments.callee.previousMethod.apply(this, arguments);

        jQuery('input[name*="select"]', jQuery(selector)).each(function (index, elem) {
            var selector = '.entity-' + jQuery(elem).val();
            jQuery(selector + ' .checked input[type*="checkbox"]').attr('checked', false);
            jQuery(selector + ' .selector.checked').removeClass('checked');
        });
    }
);

xcart.autoload(PopupButtonFeedCategoriesButton);
