/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Popup runner
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

jQuery(document).ready(
  function() {

    popup.load(
      URLHandler.buildURL(
        {
          target:       'checkoutSuccess',
          order_number: jQuery('#one-click-upsell').data('order-number'),
          widget:       'QSL\\OneClickUpsellAfterCheckout\\View\\ItemsList\\UpsellingProducts'
        }
      )
    );

    xcart.bind(
      'afterPopupPlace',
      function(e) {
        if (jQuery('.widget-qsl-oneclickupsellaftercheckout-itemslist-upsellingproducts:visible').length > 0) {
          xcart.autoload(ProductsListController);
        }
      }
    );

    if (jQuery('#one-click-upsell').data('redirect-after-add2cart')) {
      xcart.bind(
        'list.products.item.addedToCart',
        function (e, data)
        {
          if (data.item.parents('.one-click-upselling').length) {
            self.location = URLHandler.buildURL({target: 'checkout'});
          }
        }
      );
    }
  }
);
