<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\MyWishlist\Transformer\QSL\MyWishlist\Model\WishlistLink\Logic\Entity\Storefront;

use QSL\MyWishlist\Model\WishlistLink as Source;
use XCart\Factory\Logic\Entity\Storefront\WishlistLinkInterface as WishlistLinkFactory;
use XCart\Logic\Entity\Storefront\WishlistLink as Target;
use XCart\Transformer\QSL\MyWishlist\Model\WishlistLink\Logic\Entity\Storefront\WishlistLinkInterface;

class WishlistLinkDecorator implements WishlistLinkInterface
{
    public function __construct(
        private WishlistLinkFactory $requestFactory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->requestFactory->create();
        $target->setId($input->getId());

        return $target;
    }
}
