<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\MyWishlist\Transformer\QSL\MyWishlist\Model\Wishlist\Logic\Entity\Storefront;

use QSL\MyWishlist\Model\Wishlist as Source;
use QSL\MyWishlist\Model\WishlistLink;
use XCart\Factory\Logic\Entity\Storefront\WishlistInterface as WishlistFactory;
use XCart\Logic\Entity\Storefront\Wishlist as Target;
use XCart\Transformer\QSL\MyWishlist\Model\Wishlist\Logic\Entity\Storefront\WishlistInterface;

class WishlistDecorator implements WishlistInterface
{
    public function __construct(
        private WishlistFactory $requestFactory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->requestFactory->create();
        $target->setId($input->getUniqueIdentifier());
        $target->setHash($input->getHash());

        $productIds = [];
        $links = $input->getWishlistLinks()->toArray();

        /** @var WishlistLink $link */
        foreach ($links as $link) {
            $productIds[] = $link->getParentProduct()->getId();
        }
        $target->setProductIds($productIds);

        return $target;
    }
}
