<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\MyWishlist\Transformer\Logic\Entity\Storefront\NewWishlistLink\QSL\MyWishlist\Model;

use QSL\MyWishlist\Model\WishlistLink as Target;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Logic\Entity\Storefront\NewWishlistLink as Source;
use XCart\Transformer\Logic\Entity\Storefront\NewWishlistLink\QSL\MyWishlist\Model\WishlistLinkInterface;

class WishlistLinkDecorator implements WishlistLinkInterface
{
    public function __construct(
        private ReadRepositoryInterface $wishlistLinkReadRepository,
        private ReadRepositoryInterface $productReadRepository,
        private ReadRepositoryInterface $wishlistReadRepository
    ) {
    }

    public function transform(Source $input): Target
    {
        if ($wishlistLink = $input->getId()) {
            /** @var Target $target */
            $target = $this->wishlistLinkReadRepository->find($wishlistLink);
            $target->setOrderby($target->getOrderby() - 1);

            return $this->wishlistLinkReadRepository->find($wishlistLink);
        }

        $product = $this->productReadRepository->find($input->getProductId());
        $wishlist = $this->wishlistReadRepository->find($input->getWishlistId());

        $target = new Target();
        $target->setWishlist($wishlist);
        $target->setParentProduct($product);
        $target->setOrderby($input->getOrderby());
        $target->setCreationDate($input->getCreationDate());

        return $target;
    }
}
