<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\MyWishlist\Action\Storefront\WishlistMergeRequest\CreateOne;

use QSL\MyWishlist\Model\Wishlist;
use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Wishlist\MergeRequest\CreateOne\DTO\Response;
use XCart\Logic\Entity\Storefront\Wishlist\NewMergeRequest;

class Action implements ActionInterface
{
    public function __construct(
        private ReadRepositoryInterface $productReadRepository,
        private WriteRepositoryInterface $wishlistWriteRepository,
    ) {
    }

    /**
     * @param \XCart\Logic\Action\Storefront\Wishlist\MergeRequest\CreateOne\DTO\Request $request
     *
     * @return \XCart\Logic\Action\Storefront\Wishlist\MergeRequest\CreateOne\DTO\Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $profile = $request->getProfile();
        if ($profile) {
            /** @var Wishlist $wishlist */
            $wishlist = $this->wishlistWriteRepository->findOneBy([
                'customer' => $profile->getProfileId(),
            ]);

            if ($wishlist === null) {
                $wishlist = new Wishlist();
                $wishlist->setCustomer($profile);
                $wishlist->generateHash();
                $this->wishlistWriteRepository->insertEntity($wishlist);
            }

            $productIds = $request->getPayload()->getProductIds();

            foreach ($productIds as $productId) {
                $product = $this->productReadRepository->findOneBy([
                    'product_id' => $productId,
                    'enabled'    => true,
                ]);

                if ($product) {
                    $wishlist->addItem($product);
                }
            }

            return (new Response())->setPayload(
                new NewMergeRequest()
            );
        }

        return (new DefaultFailedResponse())
            ->setType('Not found')
            ->setTitle('Cannot find entity')
            ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
    }
}
