<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\MyWishlist\Action\Storefront\WishlistLink\GetOne;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class Action implements ActionInterface
{
    public function __construct(
        private ReadRepositoryInterface $productRepository,
        private ReadRepositoryInterface $wishlistLinkRepository,
        private ReadRepositoryInterface $wishlistRepository,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    /**
     * @param \XCart\Logic\Action\Storefront\WishlistLink\GetOne\DTO\Request $request
     *
     * @return \XCart\Logic\Action\Storefront\WishlistLink\GetOne\DTO\Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $wishlistLink = null;
        $profile = $request->getProfile();
        if ($profile) {
            $wishlist = $this->wishlistRepository->findOneBy([
                'customer' => $profile->getProfileId(),
            ]);

            $product = $this->productRepository->find($request->getId());

            if ($wishlist && $product) {
                $wishlistLink = $this->wishlistLinkRepository->findOneBy([
                    'wishlist' => $wishlist,
                    'parentProduct' => $product,
                ]);
            }
        }

        if ($wishlistLink === null) {
            return (new DefaultFailedResponse())
                ->setType('Not found')
                ->setTitle('Cannot find entity')
                ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
        }

        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return $this->responseAssembler->assemble($wishlistLink);
    }
}
