<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\MyWishlist\Action\Storefront\WishlistLink\CreateOne;

use Doctrine\ORM\NonUniqueResultException;
use QSL\MyWishlist\Model\Wishlist;
use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\WishlistLink\CreateOne\DTO\Response;
use XCart\Logic\Entity\Storefront\NewWishlistLink;

class Action implements ActionInterface
{
    public function __construct(
        private ReadRepositoryInterface $productReadRepository,
        private WriteRepositoryInterface $wishlistWriteRepository,
    ) {
    }

    /**
     * @param \XCart\Logic\Action\Storefront\WishlistLink\CreateOne\DTO\Request $request
     *
     * @throws NonUniqueResultException
     *
     * @return \XCart\Logic\Action\Storefront\WishlistLink\CreateOne\DTO\Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        /** @var NewWishlistLink $payload */
        $payload = $request->getPayload();

        $profile = $request->getProfile();

        $product = $this->productReadRepository->findOneBy([
            'product_id' => $payload->getProductId(),
            'enabled'    => true,
        ]);

        if (!$product) {
            return (new DefaultFailedResponse())
                ->setType('Not found')
                ->setTitle('Cannot find entities')
                ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
        }

        if (!$profile) {
            return (new DefaultFailedResponse())
                ->setType('/errors/validation')
                ->setTitle('User is not authorized')
                ->setStatus(HTTPResponse::HTTP_UNPROCESSABLE_ENTITY);
        }

        $wishlist = $this->wishlistWriteRepository->findOneBy([
            'customer' => $profile->getProfileId(),
        ]);

        if (!$wishlist) {
            $wishlist = new Wishlist();
            $wishlist->setCustomer($profile);
            $wishlist->generateHash();
            $this->wishlistWriteRepository->insertEntity($wishlist);
        }

        $wishlist->addItem($product);

        /** @var \QSL\MyWishlist\Model\WishlistLink|null $wishlistLink */
        $wishlistLink = $wishlist->getWishlistLink($product);

        return (new Response())
            ->setPayload(
                (new NewWishlistLink())
                    ->setId($wishlistLink?->getUniqueIdentifier())
                    ->setWishlistId($wishlist->getUniqueIdentifier())
                    ->setCreationDate($wishlistLink?->getCreationDate())
                    ->setOrderby($wishlistLink?->getOrderby())
                    ->setProductId($product->getUniqueIdentifier())
            );
    }
}
