<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\MyWishlist\Action\Storefront\WishlistClearRequest\CreateOne;

use QSL\MyWishlist\Model\Wishlist;
use QSL\MyWishlist\Model\WishlistLink;
use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Wishlist\ClearRequest\CreateOne\DTO\Response;
use XCart\Logic\Entity\Storefront\Wishlist\NewClearRequest;

class Action implements ActionInterface
{
    public function __construct(
        private ReadRepositoryInterface $wishlistReadRepository,
        private WriteRepositoryInterface $wishlistLinkWriteRepository,
    ) {
    }

    /**
     * @param \XCart\Logic\Action\Storefront\Wishlist\ClearRequest\CreateOne\DTO\Request $request
     *
     * @return \XCart\Logic\Action\Storefront\Wishlist\ClearRequest\CreateOne\DTO\Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $profile = $request->getProfile();
        if ($profile) {
            /** @var Wishlist $wishlist */
            $wishlist = $this->wishlistReadRepository->findOneBy([
                'customer' => $profile->getProfileId(),
            ]);

            /** @var WishlistLink $wishlistLink */
            foreach ($wishlist->getWishlistLinks() as $wishlistLink) {
                $this->wishlistLinkWriteRepository->deleteEntity($wishlistLink);
            }

            return (new Response())->setPayload(
                new NewClearRequest()
            );
        }

        return (new DefaultFailedResponse())
            ->setType('Not found')
            ->setTitle('Cannot find entity')
            ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
    }
}
