<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\MyWishlist\API\Storefront\Wishlist\DataProvider\GetOneByHash\Assembler;

use ApiPlatform\Exception\ItemNotFoundException;
use QSL\MyWishlist\Model\Wishlist;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Factory\Logic\Action\Storefront\Wishlist\GetOne\DTO\RequestInterface as RequestFactory;

class RequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestFactory $requestFactory,
        private ReadRepositoryInterface $wishlistRepository
    ) {
    }

    public function assemble($id): RequestInterface
    {
        /** @var Wishlist|null $wishlist */
        $wishlist = $this->wishlistRepository->createQueryBuilder('entity')
            ->andWhere('entity.hash = :hash')
            ->setParameter('hash', $id)
            ->getSingleResult();

        if (!$wishlist) {
            throw new ItemNotFoundException("Wishlist with hash {$id} not found");
        }

        return $this->requestFactory->create()->setId($wishlist->getUniqueIdentifier());
    }
}
