<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\MyWishlist\API;

use ApiPlatform\Core\OpenApi\OpenApi;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class OpenApiFactory extends \XLite\API\OpenApiFactory
{
    public function __invoke(array $context = []): OpenApi
    {
        $openApi = parent::__invoke($context);

        $pathItem  = $openApi->getPaths()->getPath('/api/storefront/wishlist/clear');
        $operation = $pathItem->getPost();
        $responses = $operation->getResponses();

        unset($responses['422']);

        $openApi->getPaths()->addPath(
            '/api/storefront/wishlist/clear',
            $pathItem->withPost(
                $operation->withResponses($responses)
            )
        );

        return $openApi;
    }
}
