/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

xcart.bind(
  'init-send-email-wishlist-form',
  function () {
    jQuery('.wishlist-send-mail-form button.send').click(function (e) {
      e.preventDefault();

      if (jQuery('.wishlist-send-mail-form input.email-element').validationEngine('validate')) {
        xcart.trigger('send-email-wishlist-form');
      }
    });

    jQuery('.wishlist-send-mail-form button.copy-link').click(function (e) {
      e.preventDefault();

      var params = {
        target: 'wishlist',
        action: 'copy_link',
        wishlist_id: xcart.getCommentedData(jQuery('.wishlist-send-mail-form'), 'wishlist_id')
      };

      params[xliteConfig.form_id_name] = xliteConfig.form_id;

      var url = URLHandler.buildURL(params);
      var button = jQuery('.wishlist-send-mail-form button.copy-link');

      button.prop('disabled', true);
      xcart.get(url,
        function (data) {
          var response = jQuery.parseJSON(data.responseText);

          var dummy = document.createElement('textarea');
          document.body.appendChild(dummy);
          dummy.value = URLHandler.buildURL(response);
          dummy.select();
          document.execCommand('copy');
          document.body.removeChild(dummy);

          button.prop('disabled', false);
          xcart.trigger('message', {
            message: xcart.t("Link to wishlist is copied to your clipboard"),
            type: 'success'
          });
        }
      );
    });
  }
);

xcart.bind(
  'send-email-wishlist-form',
  function () {
    var email = jQuery('.wishlist-send-mail-form input.email-element');
    var params = {
      target: 'wishlist',
      action: 'send',
      email:  email.val(),
      wishlist_id: xcart.getCommentedData(jQuery('.wishlist-send-mail-form'), 'wishlist_id')
    };

    params[xliteConfig.form_id_name] = xliteConfig.form_id;

    var url = URLHandler.buildURL(params);
    var button = jQuery('.wishlist-send-mail-form button.send');

    button.prop('disabled', true);
    xcart.get(
      url,
      function (data) {
        var block;
        block = data.status === 200 ? data.responseText : 'not-sent';
        if (block === 'not-allowed-sent') {
          window.document.location = URLHandler.buildURL({target: "login"});
        }
        button.prop('disabled', false);
      }
    );
  }
);

xcart.microhandlers.add(
  'SendEmailWishlist',
  '.wishlist-send-mail-form',
  function () {
    xcart.trigger('init-send-email-wishlist-form');
  }
);
