/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

jQuery(document).bind('pageshow', function(event)
{
  xcart.trigger('init-send-email-wishlist-form');
});

xcart.bind(
  'init-send-email-wishlist-form',
  function () {
    jQuery('.wishlist-send-mail-form button').click(function () {
      xcart.trigger('send-email-wishlist-form');
    });
  }
);

xcart.bind(
  'send-email-wishlist-form',
  function () {
    var email = jQuery('.wishlist-send-mail-form input.email-element');
    var url = URLHandler.buildURL({
      target: 'wishlist',
      action: 'send',
      email:  email.val(),
      wishlist_id: xcart.getCommentedData(jQuery('.wishlist-send-mail-form'), 'wishlist_id')
    });

    xcart.get(
      url,
      function (data) {
        var block;
        block = data === 'sent' ? 'sent' : 'not-sent';
        if (block === 'sent') {
          jQuery('.wishlist-send-mail-form .check.' + block).removeClass('hidden').animate(
            {
              opacity: 0
            }, 5000, 'swing', function () {
              jQuery(this).addClass('hidden').css('opacity', '1');
            }
          );
        }
      }
    );
  }
);
