/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

xcart.bind(
  'init-close-wishlist',
  function () {
    jQuery('a.wishlist-close').click(function () {
      xcart.trigger('send-close-wishlist', {link: jQuery(this)});

      return false;
    });
  }
);

xcart.bind(
  'send-close-wishlist',
  _.bind(
    function(event, data) {
      var link = data.link;

      xcart.get(
        link.attr('href'),
        function () {
          jQuery('a.wishlist-close').closest('.items-list')[0].controller.block.load();
        }
      );
    },
    this
  )
);

xcart.bind('list.products.loaded', function (event, data) {
    if(data.widgetClass == "QSL\\MyWishlist\\View\\ItemsList\\Product\\Customer\\WishlistPage"
        && jQuery(".items-list.wishlist-products .product-cell").length === 0){
        jQuery(".wishlist-container")
            .html("<div class='no-wishlist-products'>" + xcart.t("Feel free to add any product you like to your wishlist") + "</div>");
    }
});

xcart.bind('loginfirst', function (event, message) {
  xcart.trigger('message', {type: 'info', message: message});
});

xcart.bind('productaddedtowishlist', function (event, data) {
  jQuery('.product.productid-' + data.productid + ' a.add-to-wishlist').addClass('fa-heart').removeClass('fa-heart-o');
});

jQuery(document).ready(function () {
  xcart.microhandlers.add(
    'CloseWishlist',
    'a.wishlist-close:first',
    function () {
      xcart.trigger('init-close-wishlist');
    }
  );

  xcart.microhandlers.add(
    'AddToWishlist',
    'a.add-to-wishlist',
    function () {
      var $this = jQuery(this);
      $this.click(function () {

        if ($this.hasClass('log-in')) {
          return false;
        }

        var urlData = {
          target : 'wishlist',
          action : 'add_to_wishlist',
          list   : 1,
          product_id: $this.data('productid')
        };

        xcart.post(
          URLHandler.buildURL(urlData),
          function (XMLHttpRequest, textStatus, data, isValidXML) {
          }
        );

        return false;
      });
    }
  );
});
