/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

var wishlistUpdateCountHandler = function (event, data) {
  var count = data.count;
  var count_container = $('.wishlist-product-count');
  var heart = count_container.siblings('i');
  var old_count = parseInt(count_container.eq(0).text())? parseInt(count_container.eq(0).text()) : 0;

  var settings_icon = $('.header_settings');
  var mobile_slidebar_icon = $('.mobile_header-slidebar');

  var indicator = [settings_icon, mobile_slidebar_icon];


  // Change indication

  indicator.forEach(function (entry) {
    if (count > old_count && !entry.hasClass('recently-updated')) {
      entry.addClass('recently-updated');
    }
  });

  // Change items count

  count_container.html(count);

  if (count == 0) {
    heart.removeClass('fa-heart-o fa-heart').addClass('fa-heart-o');
  } else {
    heart.removeClass('fa-heart-o fa-heart').addClass('fa-heart');
  }


};

// Reload on event. it is used when we create profile during wishlist adding
xcart.bind('doreloadpage', function () {
  self.location.reload();
});

xcart.bind('updateWishlistProductsCount', wishlistUpdateCountHandler);

xcart.bind('popup.open', function () {
  xcart.autoload(PopupButton);
})

