/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

xcart.bind(
  'add-to-wishlist-init',
  function () {
    jQuery('button.add-to-wishlist').each(function () {
      var $this = jQuery(this);
      var flag = true;

      $this.click(function () {
        if (flag === false) {
            return;
        }

        var pid = $this.data('productid');

        if ($this.hasClass('must-be-logged-in')) {
          // Log in
          jQuery('a.log-in').first().click();
        } else {
            flag = false;
          // Add to wishlist
          xcart.post(
            URLHandler.buildURL({ target: 'wishlist', action: 'add_to_wishlist', 'product_id':  pid}),
            function () {

              flag = true;
            }
          );

          xcart.bind('updateWishlistButtonText', function (event, data) {
            var text = data.text;
            $this = $('button.add-to-wishlist:not(.already-in-wishlist)');

            $this.find('.wishlist-link-label').html(text);
            $this.find('i').removeClass('fa-heart-o fa-heart').addClass('fa-heart');
            $this.addClass('added-to-wishlist');
          });
        }
      });
    });
  }
);

xcart.microhandlers.add(
  'AddToWishlistInit',
  'button.add-to-wishlist',
  function () {
    xcart.trigger('add-to-wishlist-init');
  }
);
