/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Selector controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonElement.prototype.handlers.push(
  {
    canApply: function () {
      return this.$element.attr('name')
        && this.$element.attr('name').search(/assignedMembershipTTLType..type/) != -1
    },
    handler: function () {
      var handler = function () {
        var elm = jQuery(this)
        var inp = jQuery(':input', this.form).filter(
          function () {
            var e = jQuery(this)
            return e.attr('name')
              && e.attr('name').search(/assignedMembershipTTLType..value/) != -1
          }
        ).eq(0).parents('.text-row').eq(0)
        if (elm.val()) {
          inp.show()
        } else {
          inp.hide()
        }
      }
      this.$element.change(handler)
      handler.apply(this.element)
    }
  }
)
