<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\FlyoutCategoriesMenu\View;

use QSL\FlyoutCategoriesMenu\Main;
use XCart\Extender\Mapping\Extender;
use XLite\Core\Database;
use XLite\Model\Category;

/**
 * @Extender\Mixin
 */
class Slidebar extends \XLite\View\Slidebar
{
    protected function getCategoriesListItemCSSClass(): string
    {
        $class = ['slidebar-categories'];

        if (
            Main::isFirstLevelCategoriesLoadingWithoutAjaxInMobileMenu()
            && ($rootCategoryId = (Database::getRepo(Category::class)?->getRootCategory()?->getCategoryId() ?? 0))
        ) {
            $class[] = 'ajax-category category-id-' . $rootCategoryId;
        }

        return implode(' ', $class);
    }
}
