<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\FlyoutCategoriesMenu;

use XLite\Core\Config;
use XLite\Module\AModule;

class Main extends AModule
{
    public static function getAllowedDepthWithoutAjaxForDesktop(): int
    {
        return (int) Config::getInstance()->QSL->FlyoutCategoriesMenu->allowed_depth_without_ajax;
    }

    public static function getAllowedDepthWithoutAjaxForMobile(): int
    {
        return (int) Config::getInstance()->QSL->FlyoutCategoriesMenu->allowed_depth_without_ajax_mob;
    }

    public static function isFirstLevelCategoriesLoadingWithoutAjaxInMobileMenu(): bool
    {
        return static::getAllowedDepthWithoutAjaxForMobile() <= 0;
    }
}
