<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\FlyoutCategoriesMenu\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;

/**
 * Add the option that indicates the amount of menu levels in mobile menu to render without Ajax (Default: 0).
 */
final class UpgradeTo552build0
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->fixtureLoader->loadYaml(
            LC_DIR_MODULES . 'QSL/FlyoutCategoriesMenu/resources/hooks/upgrade/5.5/2.0/upgrade.yaml'
        );
    }
}
