jQuery(document).ready(function () {
  let ajaxCategories = {
    init: function () {
      let self = this;

      $('#slidebar .ajax-category').each(function () {
        self.initMobileHandler($(this));
      });
    },
    ajaxConfig: function (categoryId) {
      return {
        url: xliteConfig.script +
          '?target=category&widget=\\QSL\\FlyoutCategoriesMenu\\View\\TopCategoriesMobile' +
          '&mode=ajax' +
          '&category_id=' + categoryId
      };
    },
    initMobileHandler: function (elem) {
      let self = this;

      elem.off('click').on('click', function () {
        let item = $(this);

        if (item.find('ul').length === 0) {
          let categoryId = item.attr('class').replace(/^.*category-id-(\d+).*$/, '$1');

          assignWaitOverlay(item.closest('.mm-menu'));

          jQuery.ajax(self.ajaxConfig(categoryId)).done(function (data) {
            let loadedList = $(data).find('ul').removeClass('flyout-menu');
            let api = jQuery('#slidebar').data('mmenu');

            item.off('click').removeClass('ajax-category').closest('li').append(loadedList);
            api.init(loadedList);
            self.init();

            unassignShadeOverlay(item.closest('.mm-menu'));

            item.closest('li').find('[data-target]').trigger('click');
          });
          return false;
        }
      });
    }
  };

  ajaxCategories.init();
});
