/**
 * Ajax categories
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

jQuery(document).ready(function () {
  let ajaxCategories = {
    init: function () {
      let self = this;

      $('#sidebar-first .ajax-category').each(function () {
        self.initCommonHandler($(this));
      });
    },
    ajaxConfig: function (categoryId) {
      return {
        url: xliteConfig.script +
          '?target=category&widget=\\QSL\\FlyoutCategoriesMenu\\View\\TopCategories' +
          '&mode=ajax' +
          '&category_id=' + categoryId
      };
    },
    setLoadingState: function (elem) {
      elem.append($('<ul class="sublevel"><li class="loading"><a>Loading</a></li></ul>'));
    },
    unsetLoadingState: function (elem) {
      elem.find('ul').remove();
    },
    initCommonHandler: function (elem) {
      let self = this;

      elem.off('mouseenter').on('mouseenter', function () {
        let item = $(this);

        if (item.find('ul').length === 0) {
          let categoryId = item.attr('class').replace(/^.*category-id-(\d+).*$/, '$1');

          self.setLoadingState(item);

          jQuery.ajax(self.ajaxConfig(categoryId)).done(function (data) {
            let loadedList = $(data).find('ul');

            self.unsetLoadingState(item);
            item.off('mouseenter').removeClass('ajax-category').append(loadedList);
            self.init();
          });
        }
      });
    }
  };

  ajaxCategories.init();
});
