<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CustomerSatisfaction\EventListener;

use QSL\CustomerSatisfaction\Model\Survey;
use XCart\Event\EntityGenerator\OrderPreClearEvent;
use XLite\Core\Database;

final class OrderPreClearListener
{
    public function onOrderPreClear(OrderPreClearEvent $event): void
    {
        Database::getRepo(Survey::class)?->createPureQueryBuilder()
            ->delete(Survey::class)
            ->execute();
    }
}
