/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * VoteBar Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function VoteBarController(base)
{
  this.callSupermethod('constructor', arguments);

  var form = jQuery(this.base).closest('form').get(0);
}

extend(VoteBarController, AController);

// Controller name
VoteBarController.prototype.name = 'VoteBarController';

// Find pattern
VoteBarController.prototype.findPattern = '.vote-bar';

// Controller associated main widget
VoteBarController.prototype.block = null;

// Controller associated buttons block widget
VoteBarController.prototype.buttonsBlock = null;

// Initialize controller
VoteBarController.prototype.initialize = function()
{
  var o = this;

  this.base.bind(
    'reload',
    function(event, box) {
      event.stopImmediatePropagation();
      o.bind(box);
    }
  );
};

function VoteBarClick(obj) {

  if (!obj._previous) {
    obj._previous = jQuery(obj).parent('li').prevAll();
  }

  if (!obj._all) {
    obj._all = jQuery(obj).parent('li').parent('ul').children('li');
  }

  obj._all.each(function(index) {
    jQuery(this).find('span').removeClass('full');
  });

  jQuery(obj).find('span').addClass('full');

  obj._previous.each(function(index) {
    jQuery(this).find('span').addClass('full');
  });

  if (!obj._rating) {
    obj._rating = parseInt(jQuery(obj).parent('li').attr('class').match(/\d+/)) + 1;
  }
  obj._post_var = jQuery(obj).parentsUntil('div.vote-bar').parent('div.vote-bar').attr('id');

  jQuery(obj).parentsUntil('form').parent('form').find('input[name='+obj._post_var+']').val(obj._rating);

  return false;
}

/**
 * Main widget
 */
function VoteBarView(base, productId, returnTarget)
{
  this.callSupermethod('constructor', arguments);

  this.productId = productId;
  this.returnTarget = returnTarget;

  this.linkClickHandler = function(event)
  {
    event.stopPropagation();

    return false;
  };
}

extend(VoteBarView, ALoadable);

// Product id
VoteBarView.prototype.productId = null;

// Return target (product page or product reviews page)
VoteBarView.prototype.returnTarget = null;

// Rating
VoteBarView.prototype.rating = null;

// Shade widget
VoteBarView.prototype.shadeWidget = true;

// Widget target
VoteBarView.prototype.widgetTarget = 'customer_survey';

// Widget class name
VoteBarView.prototype.widgetClass = '\\QSL\\CustomerSatisfaction\\View\\Stars';

// Previous value of 'action' input
VoteBarView.prototype.prevFormActionValue = '';
VoteBarView.prototype.prevFormActionInput = null;
VoteBarView.prototype.prevShadeWidget = null;

// Postprocess widget
VoteBarView.prototype.postprocess = function(isSuccess, initial)
{
  this.callSupermethod('postprocess', arguments);

  if (isSuccess) {

    var o = this;

    jQuery(this.base).find('span.editable').bind(
      'click',
      function(event)
      {
        VoteBarClick(this);
        return o.rateProduct(event, jQuery(this));
      }
    );
  }
};

// Get additional parameters
VoteBarView.prototype.getParams = function(params)
{
  params = this.callSupermethod('getParams', arguments);

  return params;
};

xcart.autoload(VoteBarController);

CommonForm.elementControllers.push(
  {
    pattern: '.vote-bar ul li span.editable',
    handler: function () {
      jQuery(this)
        .hover(
          function() {
            if (!this._previous) {
              this._previous = jQuery(this).parent('li').prevAll();
            }

            jQuery(this).find('span').addClass('over');

            this._previous.each(function(index) {
              jQuery(this).find('span').addClass('over');
            });
          }, function() {
            if (!this._previous) {
              this._previous = jQuery(this).parent('li').prevAll();
            }

            this._previous.each(function(index) {
              jQuery(this).find('span').removeClass('over');
            });

            jQuery(this).find('span').removeClass('over');
          })
        .click(function() {
          return VoteBarClick(this);
        });
    }
  }
);
