<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\View\ItemsList\Model\Product\Admin;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Search extends \XLite\View\ItemsList\Model\Product\Admin\Search
{
    /**
     * @return array
     */
    protected function defineColumns()
    {
        return parent::defineColumns() + [
                'costPrice' => [
                    static::COLUMN_NAME    => static::t('Cost price'),
                    static::COLUMN_CLASS   => 'XLite\View\FormField\Inline\Input\Text\Price',
                    static::COLUMN_PARAMS  => ['min' => 0],
                    static::COLUMN_ORDERBY => 450,
                ]
            ];
    }

    /**
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();

        $list[] = 'modules/QSL/CostPrice/items_list/style.less';

        return $list;
    }
}
