<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\View\ItemsList\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("XC\ProductVariants")
 * @Extender\After("QSL\CostPrice")
 */
class ProductVariant extends \XC\ProductVariants\View\ItemsList\Model\ProductVariant
{
    /**
     * @return array
     */
    protected function defineColumns()
    {
        return parent::defineColumns() + [
                'costPrice'  => [
                    static::COLUMN_NAME      => static::t('Cost Price'),
                    static::COLUMN_SUBHEADER => static::t('Default') . ': ' . $this->formatPrice($this->getProduct()->getCostPrice()),
                    static::COLUMN_CLASS     => 'QSL\CostPrice\Module\XC\ProductVariants\View\FormField\Inline\Input\Text\CostPrice',
                    static::COLUMN_EDIT_ONLY => true,
                    static::COLUMN_ORDERBY   => 450,
                ],
            ];
    }
}
