<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\View\FormField\Inline\Input\Text;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Depend("XC\ProductVariants")
 */
class CostPrice extends \XC\ProductVariants\View\FormField\Inline\Input\Text\Price
{
    /**
     * @return string
     */
    protected function defineFieldClass()
    {
        return 'XLite\View\FormField\Input\Text';
    }

    /**
     * @return string
     */
    protected function getPlaceholder()
    {
        return $this->getProduct()
            ? $this->formatPrice($this->getProduct()->getCostPrice())
            : parent::getPlaceholder();
    }
}
