<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\Model;

use Doctrine\ORM\Mapping as ORM;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("XC\ProductVariants")
 * @Extender\After("QSL\CostPrice")
 */
class ProductVariant extends \XC\ProductVariants\Model\ProductVariant
{
    /**
     * @var float
     *
     * @ORM\Column (type="decimal", precision=14, scale=4)
     */
    protected $costPrice = 0.0000;

    /**
     * @return float
     */
    public function getCostPrice()
    {
        return $this->costPrice ?: $this->getDefaultCostPriceValue();
    }

    /**
     * @return float|null
     */
    public function getDefaultCostPriceValue()
    {
        return  \XLite::isAdminZone() ? ($this->costPrice ?: null) : $this->getProduct()->getCostPrice();
    }

    /**
     * @param $costPrice
     *
     * @return $this
     */
    public function setCostPrice($costPrice)
    {
        $this->costPrice = (float) $costPrice;

        return $this;
    }
}
