<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\Model;

use XCart\Extender\Mapping\Extender;

/**
 * Class Product
 *
 * @Extender\Mixin
 * @Extender\Depend("XC\ProductVariants")
 * @Extender\After("QSL\CostPrice")
 */
class OrderItem extends \XLite\Model\OrderItem
{
    /**
     * Get clear cost price value
     *
     * @return float
     */
    public function getProductCostPrice()
    {
        return !is_null($this->getProductVariantCostPrice())
            ? $this->getProductVariantCostPrice()
            : parent::getProductCostPrice();
    }

    /**
     * Get clear cost price value
     *
     * @return float
     */
    public function getProductVariantCostPrice()
    {
        return $this->getVariant()
            ? $this->getVariant()->getCostPrice()
            : null;
    }
}
