<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\Logic\Import\Processor;

use XCart\Extender\Mapping\Extender;

/**
 * Class Products
 *
 * @Extender\Mixin
 * @Extender\Depend("XC\ProductVariants")
 * @Extender\After("QSL\CostPrice")
 */
abstract class Products extends \XLite\Logic\Import\Processor\Products
{
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $columns += [
            static::VARIANT_PREFIX . 'CostPrice'    => [
                static::COLUMN_IS_MULTIROW => true,
            ],
        ];

        return $columns;
    }
    // {{{ Verification

    /**
     * Get messages
     *
     * @return array
     */
    public static function getMessages()
    {
        return parent::getMessages() + [
                'VARIANT-COSTPRICE-FMT'       => 'Wrong variant price format',
            ];
    }
    /**
     * Verify 'variantCostPrice' value
     *
     * @param mixed $value Value
     * @param array $column Column info
     *
     * @return void
     */
    protected function verifyVariantCostPrice($value, array $column)
    {
        if (!$this->verifyValueAsEmpty($value)) {
            foreach ($value as $val) {
                if (!$this->verifyValueAsFloat($val)) {
                    $this->addWarning('VARIANT-COSTPRICE-FMT', ['column' => $column, 'value' => $val]);
                }
            }
        }
    }

    // }}}

    // {{{ Import

    /**
     * Import 'variantCostPrice' value
     *
     * @param \XLite\Model\Product $model Product
     * @param mixed $value Value
     * @param array $column Column info
     */
    protected function importVariantCostPriceColumn(\XLite\Model\Product $model, $value, array $column)
    {
        foreach ($this->variants as $rowIndex => $variant) {
            $variant->setCostPrice($this->normalizeValueAsFloat($value[$rowIndex] ?? 0));
        }
    }
    // }}}
}
