<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\Logic\Export\Step;

use XCart\Extender\Mapping\Extender;

/**
 * Class Products
 *
 * @Extender\Mixin
 * @Extender\Depend("XC\ProductVariants")
 * @Extender\After("QSL\CostPrice")
 */
abstract class Products extends \XLite\Logic\Export\Step\Products
{
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        if ($this->generator->getOptions()->attrs !== 'none') {
            $newColumns = [];
            foreach ($columns as $k => $v) {
                $newColumns[$k] = $v;
                if ($k == 'variantPrice') {
                    $newColumns[static::VARIANT_PREFIX . 'CostPrice'] = [static::COLUMN_MULTIPLE => true];
                }
            }

            return $newColumns;
        }

        return $columns;
    }

    /**
     * Get column value for 'variantCostPrice' column
     *
     * @param array $dataset Dataset
     * @param string $name Column name
     * @param integer $i Subcolumn index
     *
     * @return string
     */
    protected function getVariantCostPriceColumnValue(array $dataset, $name, $i)
    {
        return empty($dataset['variant'])
            ? ''
            : $this->getColumnValueByName($dataset['variant'], 'costPrice');
    }
}
