<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\API\Endpoint\ProductVariant\Transformer;

use XCart\Extender\Mapping\Extender;
use XC\ProductVariants\API\Endpoint\ProductVariant\DTO\ProductVariantOutput as OutputDTO;
use XC\ProductVariants\API\Endpoint\ProductVariant\Transformer\OutputTransformer as ExtendedOutputTransformer;
use QSL\CostPrice\Module\XC\ProductVariants\API\Endpoint\ProductVariant\DTO\ProductVariantOutput as ModuleOutputDTO;
use QSL\CostPrice\Module\XC\ProductVariants\Model\ProductVariant as Model;

/**
 * @Extender\Mixin
 * @Extender\Depend({"XC\ProductVariants"})
 */
class OutputTransformer extends ExtendedOutputTransformer
{
    /**
     * @param Model $object
     */
    public function transform($object, string $to, array $context = []): OutputDTO
    {
        /** @var ModuleOutputDTO $dto */
        $dto = parent::transform($object, $to, $context);

        $dto->cost_price = $object->getCostPrice();

        return $dto;
    }
}
