<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Module\XC\ProductVariants\API\Endpoint\ProductVariant\DTO;

use Symfony\Component\Validator\Constraints as Assert;
use XCart\Extender\Mapping\Extender;
use XC\ProductVariants\API\Endpoint\ProductVariant\DTO\ProductVariantUpdate as ExtendedInput;

/**
 * @Extender\Mixin
 * @Extender\Depend({"XC\ProductVariants"})
 */
class ProductVariantUpdate extends ExtendedInput
{
    /**
     * @Assert\PositiveOrZero()
     * @var float|null
     */
    public ?float $cost_price = null;
}
