<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Model;

use XCart\Extender\Mapping\Extender;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Extender\Mixin
 */
abstract class Product extends \XLite\Model\Product
{
    /**
     * @var float
     *
     * @ORM\Column (type="decimal", precision=14, scale=4)
     */
    protected $costPrice = 0.0000;

    /**
     * @return float
     */
    public function getCostPrice()
    {
        return $this->costPrice ?: $this->getDefaultCostPriceValue();
    }

    /**
     * @return float
     */
    public function getDefaultCostPriceValue()
    {
        return  \XLite::isAdminZone() ? $this->costPrice : $this->getPrice();
    }

    /**
     * @param $value
     *
     * @return $this
     */
    public function setCostPrice($value)
    {
        $this->costPrice = (float) $value;

        return $this;
    }
}
