<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Model;

use XCart\Extender\Mapping\Extender;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class represents an order
 * @Extender\Mixin
 */
class Order extends \XLite\Model\Order
{
    /**
     * Gross Profit
     *
     * @var float
     *
     * @ORM\Column (type="decimal", precision=14, scale=4)
     */
    protected $grossProfit = 0.0000;

    /**
     * @return float
     */
    public function getGrossProfit()
    {
        return $this->grossProfit;
    }

    /**
     * @param float $grossProfit
     */
    public function setGrossProfit($grossProfit)
    {
        $this->grossProfit = $grossProfit;

        return $this;
    }

    /**
     * Called when an order successfully placed by a client
     *
     * @return void
     */
    public function processSucceed()
    {
        parent::processSucceed();

        $this->calculateGrossProfit();
    }

    /**
     * Calculate initial order values
     *
     * @return void
     */
    public function calculateGrossProfit()
    {
        $gross = 0;

        /** @var \QSL\CostPrices\Model\OrderItem $item */
        foreach ($this->getItems() as $item) {
            $gross += $item->getSubtotal() - $item->calculateCostPriceSubtotal();
        }

        $gross = $this->getCurrency()->roundValue($gross);

        $this->setGrossProfit($gross);
    }
}
