<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Logic\Export\Step;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Products extends \XLite\Logic\Export\Step\Products
{
    /**
     * Define columns
     *
     * @return array
     */
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $newColumns = [];

        foreach ($columns as $k => $v) {
            $newColumns[$k] = $v;
            if ($k == 'price') {
                $newColumns['costPrice'] = [];
            }
        }

        return $newColumns;
    }

    /**
     * Get column value for 'cost Price' column
     *
     * @param array   $dataset Dataset
     * @param string  $name    Column name
     * @param integer $i       Subcolumn index
     *
     * @return string
     */
    protected function getCostPriceColumnValue(array $dataset, $name, $i)
    {
        $result = [];

        $result[] = $dataset['model']->getCostPrice();

        return $result;
    }
}
