<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\Logic\BulkEdit;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\BulkEditing")
 */
class Scenario extends \XC\BulkEditing\Logic\BulkEdit\Scenario
{
    /**
     * @return array
     */
    protected static function defineScenario()
    {
        $result = parent::defineScenario();
        $result['product_price_and_membership']['fields']['default']['costPrice'] = [
            'class'    => 'QSL\CostPrice\Logic\BulkEdit\Field\Product\CostPrice',
            'options' => [
                'position' => 110,
            ],
        ];

        return $result;
    }
}
