<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CostPrice\API\Endpoint\Order\Transformer;

use XCart\Extender\Mapping\Extender;
use XLite\API\Endpoint\Order\DTO\BaseOutput;
use XLite\API\Endpoint\Order\Transformer\OutputTransformerAbstract as ExtendedOutputTransformerAbstract;
use QSL\CostPrice\API\Endpoint\Order\DTO\OrderOutput as ModuleOrderOutputDTO;
use QSL\CostPrice\Model\Order;

/**
 * @Extender\Mixin
 */
class OutputTransformerAbstract extends ExtendedOutputTransformerAbstract
{
    /**
     * @param Order $object
     */
    protected function basicTransform(BaseOutput $dto, $object, string $to, array $context = []): BaseOutput
    {
        /** @var ModuleOrderOutputDTO $dto */
        $dto = parent::basicTransform($dto, $object, $to, $context);

        $dto->gross_profit = $object->getGrossProfit();

        return $dto;
    }
}
