<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\ColorSwatches\Transformer\XLite\Model\AttributeValue\Logic\Entity\Storefront;

use XCart\Logic\Entity\Storefront\ProductAttributeValue as Target;
use XCart\Logic\Entity\Storefront\SwatchImage;
use XCart\Transformer\XLite\Model\AttributeValue\Logic\Entity\Storefront\AttributeValueInterface;
use XLite\Model\AttributeValue\AAttributeValue as Source;
use XLite\Model\Product as ProductSource;

class AttributeValueDecorator implements AttributeValueInterface
{
    public function __construct(
        private AttributeValueInterface $inner
    ) {
    }

    public function transform(Source $input, ProductSource $productSource): Target
    {
        $target = $this->inner->transform($input, $productSource);

        if ($input->getAttribute()->isColorSwatchesAttribute()) {
            /** @var \QSL\ColorSwatches\Model\Swatch $inputSwatch */
            $inputSwatch = $input->detectSwatch();

            if ($inputSwatchColor = $inputSwatch->getColor()) {
                $target->setSwatchColor($inputSwatchColor);
            }

            if ($inputSwatchImage = $this->getTransformedSwatchImage($inputSwatch)) {
                $target->setSwatchImage($inputSwatchImage);
            }
        }

        return $target;
    }

    private function getTransformedSwatchImage(\QSL\ColorSwatches\Model\Swatch $inputSwatch): ?SwatchImage
    {
        if ($inputSwatchImage = $inputSwatch->getImage()) {
            return (new SwatchImage())
                ->setUrl($inputSwatchImage->getURL())
                ->setWidth($inputSwatchImage->getWidth())
                ->setHeight($inputSwatchImage->getHeight());
        }

        return null;
    }
}
