<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\ColorSwatches\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Database;

/**
 * @Extender\Mixin
 */
class Attribute extends \XLite\Controller\Admin\Attribute
{
    protected function doActionUpdate()
    {
        parent::doActionUpdate();

        $attribute = $this->getModelForm()?->getModelObject();
        if ($attribute && $attribute->getDisplayMode() !== $attribute::COLOR_SWATCHES_MODE) {
            foreach ($attribute->getAttributeOptions() as $attributeOption) {
                $attributeOption->setSwatch(null);
            }
        }

        Database::getEM()->flush();
    }
}
