/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Color swatches controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function ColorSwatchesController (elm) {
  Base.apply(this);

  this.box = jQuery(elm);

  this.initialize();
}

extend(ColorSwatchesController, Base);

ColorSwatchesController.prototype.box = null;

ColorSwatchesController.prototype.initialize = function () {
  this.box.find('input').click(_.bind(this.handleSwatchClick, this));
  this.box.find('input').focus(_.bind(this.handleSwatchInputFocus, this));
  this.box.find('input').blur(_.bind(this.handleSwatchInputBlur, this));
  if (this.box.hasClass('select-shown')) {
    this.box.find('a').click(_.bind(this.handleSwatchClick, this));
  }
  this.placeTitle();
};

ColorSwatchesController.prototype.placeTitle = function () {
  const selected_value = this.box.find('li.selected a').data('name');
  this.box.parents('.color-swatches-wrapper').find('.title .selected-value').text(selected_value);
};

ColorSwatchesController.prototype.handleSwatchClick = function (event) {
  const target = $(event.currentTarget);
  const parent_li = target.closest('li.block-value');
  const detailsBox = $('div.product-details');
  const selected_attr_id = parent_li.data('option-id');

  if (parent_li.hasClass('cs-disabled') || parent_li.hasClass('unavailable')) {
    return false;
  }

  this.box.children().removeClass('selected');
  parent_li.addClass('selected');

  if(target.is("input")) {
    target.change();
  }

  this.placeTitle();

  if (selected_attr_id !== undefined) {
    this.box.parent('.blocks').siblings('select').val(selected_attr_id).change();
  }

  if (detailsBox.length) {
    const ctrl = detailsBox.get(0).controller;
    const pid = detailsBox.find('input[name="product_id"]').val();
    if (ctrl && typeof (ctrl.block) !== 'undefined' && typeof (ctrl.block.loadVariantsImages) !== 'undefined' && pid) {
      ctrl.block.loadVariantsImages(pid);
    }
  }

  return false;
};

ColorSwatchesController.prototype.handleSwatchInputFocus = function (event) {
  $(event.currentTarget)
    .closest('li.block-value')
    .addClass('focused');
};

ColorSwatchesController.prototype.handleSwatchInputBlur = function (event) {
  $(event.currentTarget)
    .closest('li.block-value')
    .removeClass('focused');
};

ColorSwatchesController.prototype.getEventNamespace = function () {
  return 'colorswatches.selector';
};

xcart.microhandlers.add('.color-swatches', '.color-swatches', function () {
  new ColorSwatchesController(this);
});

xcart.bind(
  'product.details.quantityBox.initialize',
  function () {
    xcart.microhandlers.run('.color-swatches');
  }
);
(function () {
  xcart.bind('block.product.details.postprocess', function () {
    xcart.registerWidgetsParamsGetter(
      'update-product-page',
      function (product) {
        const result = getAttributeValuesParams(product);
        const base = '.product-info-' + product.product_id;

        jQuery('ul.attribute-values input[type=radio]:checked', jQuery(base).last()).each(function (index, elem) {
          result.attribute_values += jQuery(elem).data('attribute-id') + '_' + jQuery(elem).val() + ',';
        });

        return result;
      }
    );

    xcart.registerTriggersBind('update-product-page',
      function () {
        const handler = function ($this) {
          xcart.trigger('update-product-page', jQuery('input[name="product_id"]', $this).val());
        };

        const $this = jQuery('ul.attribute-values').closest('.product-details-info').find('form.product-details');

        jQuery('ul.attribute-values input[type=\'radio\']').unbind('change').bind('change', function (e) {
          handler($this);
        });
      }
    );
  });

  xcart.bind(
    'loader.loaded',
    function (event, data) {
      if (data && typeof (data.base) !== 'undefined' && data.base && data.base.is('.attribute-values')) {
        data.base.find('.color-swatches').each(
          function () {
            new ColorSwatchesController(this);
          }
        );
      }
    }
  );

  decorate(
    'AttributeValues',
    'postprocess',
    // eslint-disable-next-line no-unused-vars
    function (isSuccess) {
      arguments.callee.previousMethod.apply(this, arguments);

      this.base.find('input').change(
        _.bind(
          function () {
            this.load();
          },
          this
        )
      );
    }
  );

  decorate(
    'AttributeValues',
    'getParams',
    // eslint-disable-next-line no-unused-vars
    function (params) {
      const parameters = arguments.callee.previousMethod.apply(this, arguments);
      const form = this.base.closest('form');

      form.find('input[name^="attribute_values"]:checked').each(
        function () {
          const elm = jQuery(this);
          parameters['attribute_values[' + elm.data('attributeId') + ']'] = elm.val();
        }
      );

      return parameters;
    }
  );

})();
